IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_SCA_Antipassback') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_SCA_Antipassback
END
GO


CREATE FUNCTION [dbo].[CF_SCA_Antipassback](@pId_Cliente INT, @pId_Acceso SMALLINT, @pFecha DATETIME, @pTipoAcceso CHAR(1), @pFechaEvento DATETIME)
RETURNS CHAR(1)
AS
BEGIN
DECLARE @Flag_Estado_Acceso			CHAR(1)
DECLARE @Cant_Horas_Antipassback	TINYINT
DECLARE @Flag_Evento				TINYINT
DECLARE @UltTipoAcceso				CHAR(1)
DECLARE @Tiempo_Antirebote			INT
DECLARE @UltPasadaExistosa			DATETIME
DECLARE @LimiteAntirrebote			DATETIME
DECLARE @CD_Controlador_Tipo		CHAR(1)
DECLARE @Id_Cliente_Master			INT

-------------------------------------------------------------------------------------------------------------------------------------

SET @Id_Cliente_Master = ISNULL((SELECT Id_Cliente FROM CD_Cli_Master WHERE Id_Cliente = @pId_Cliente), 0)

IF(@Id_Cliente_Master <> 0)
BEGIN
	SET @Flag_Estado_Acceso = 'O'
	RETURN @Flag_Estado_Acceso
END

-------------------------------------------------------------------------------------------------------------------------------------

-------------------------------------------------------------------------------------------------------------------------------------

SELECT 
@Cant_Horas_Antipassback	= ISNULL(Flag_Antipassback, 0), 
@Flag_Evento				= ISNULL(Flag_Evento, 0),
@Tiempo_Antirebote			= ISNULL(Tiempo_Antirebote, 0)		/*@Tiempo_Antirebote en centesimas de segundo*/
FROM CD_Accesos 
WHERE 
Id_Acceso = @pId_Acceso

-------------------------------------------------------------------------------------------------------------------------------------

--02/07/2021 Agregado
SELECT 
TOP 1
@CD_Controlador_Tipo = ISNULL(Tipo, 'E')
FROM CD_Controladores 
WHERE 
Id_Acceso = @pId_Acceso
ORDER BY Id_Controlador

-------------------------------------------------------------------------------------------------------------------------------------

IF(@Cant_Horas_Antipassback = 0)
BEGIN
	--SET @Cant_Horas_Antipassback = 16 --Horas
	SET @Flag_Estado_Acceso = 'O'
	RETURN @Flag_Estado_Acceso
END


IF(@Flag_Evento <> 0)
BEGIN
	-- Modo Evento (Ej. Partido)
	
	SET @UltPasadaExistosa =ISNULL((SELECT MAX(CE.Fecha)
								FROM CD_ES CE
								WHERE 
								CE.Id_Cliente = @pId_Cliente
								AND CE.Id_ES =	(SELECT MAX(CE2.Id_ES) FROM CD_ES CE2 WHERE CE2.Id_Cliente = @pId_Cliente AND CE2.Resultado = 'S' AND CE2.Id_Acceso IN (SELECT Id_Acceso FROM CD_Accesos WHERE Flag_Evento = 1 ))
								AND CE.Fecha >= @pFechaEvento),'19000101')
	
	IF(@UltPasadaExistosa <> '19000101')
	BEGIN
		/*Ya paso una vez por Molinete durante el evento*/
		SET @LimiteAntirrebote = DATEADD(SS, (@Tiempo_Antirebote/100), @UltPasadaExistosa)		
		
		SET @UltTipoAcceso =	(SELECT ISNULL(MAX(CE.Tipo), 'S')
								FROM CD_ES CE
								WHERE 
								CE.Id_Cliente = @pId_Cliente
								AND CE.Id_ES =	(SELECT MAX(CE2.Id_ES) FROM CD_ES CE2 WHERE CE2.Id_Cliente = @pId_Cliente AND CE2.Resultado = 'S' AND CE2.Id_Acceso IN (SELECT Id_Acceso FROM CD_Accesos WHERE Flag_Evento = 1 ))
								AND CE.Fecha >= @pFechaEvento
								AND @pFecha >= @LimiteAntirrebote)

		IF(@UltTipoAcceso = @pTipoAcceso)
		BEGIN
			IF(@pTipoAcceso = 'E')
			BEGIN
				--Ya Ingresado
				SET @Flag_Estado_Acceso = 'Y'
				RETURN @Flag_Estado_Acceso
			END
			
			IF(@pTipoAcceso = 'S')
			BEGIN
				--No Registro Entrada
				SET @Flag_Estado_Acceso = 'S'
				RETURN @Flag_Estado_Acceso
			END
		END
	END
	ELSE
	BEGIN
		/*Nunca Paso*/
		SET @Flag_Estado_Acceso = 'O'
		RETURN @Flag_Estado_Acceso
	END
END
ELSE
BEGIN

	-- Modo "Normal"
	SET @UltTipoAcceso = (SELECT ISNULL(MAX(CE.Tipo), 'S')
		FROM CD_ES CE
		WHERE CE.Id_Cliente = @pId_Cliente
		  AND CE.Resultado = 'S'
		  AND CE.Fecha <= DATEADD(SECOND, (-@Tiempo_Antirebote / 100), @pFecha)
		  AND CE.Fecha >= DATEADD(HOUR, (-@Cant_Horas_Antipassback), @pFecha)
	)

	IF(@UltTipoAcceso = @pTipoAcceso)
	BEGIN
		IF(@pTipoAcceso = 'E')
		BEGIN
			IF(@CD_Controlador_Tipo = 'A')
			BEGIN
				--No Registro Salida
				SET @Flag_Estado_Acceso = 'E'
			END
			ELSE
			BEGIN
				--Ya ingresado. Antipassback
				SET @Flag_Estado_Acceso = 'Y'				
			END

			RETURN @Flag_Estado_Acceso
			/*
			02/07/2021 Se modifico
			--No Registro Salida
			SET @Flag_Estado_Acceso = 'E'
			RETURN @Flag_Estado_Acceso
			*/
		END
		
		IF(@pTipoAcceso = 'S')
		BEGIN
			--No Registro Entrada
			SET @Flag_Estado_Acceso = 'S'
			RETURN @Flag_Estado_Acceso
		END
	END						

END

RETURN ISNULL(@Flag_Estado_Acceso, 'O')

END
